//
//  GHFirmwareResult.h
//  Garmin Health
//
//  Created by Johnson, Garrett on 6/13/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//


/**
 *  Enum of firmware check status.
 */
typedef NS_ENUM(NSInteger, GHFirmwareStatus) {
    /**
     * New firmware available.
     */
    GHFirmwareStatusNewAvailable = 0,
    /**
     *  Firmware is up to date.
     */
    GHFirmwareStatusUpToDate = 1,
    /**
     *  Error occured retrieving firmware.
     */
    GHFirmwareStatusError = 2
};


#pragma mark -
/**
 *  Firmware update from Garmin servers.
 */
@interface GHFirmwareResult : NSObject <NSCoding>

/** name of the firmware file. */
@property (nonatomic, readonly) NSString *fileName;

/** Version of the firmware file. */
@property (nonatomic, readonly) NSString *version;

/** NS_UNAVAILABLE */
+ (instancetype)new NS_UNAVAILABLE;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
